
rm(list = ls())

library(readr)
library(readxl)
library(dplyr)
library(writexl)
options(scipen=999)

EMPAQUETADOS <- read.csv("~/EMPAQUETAMIENTO_FIJO_6.csv", sep=";", dec=",")
EMPAQUETADOS$ID_EMPRESA <- ifelse(EMPAQUETADOS$ID_EMPRESA == "890905065", "900092385", EMPAQUETADOS$ID_EMPRESA)

MUNICIPIOS <- read_excel("~/a. IF.xlsx")

IF <- filter(EMPAQUETADOS, ID_SERVICIO_PAQUETE == 1)

IF_R <- filter(IF, ID_SEGMENTO != "107")
IF_R <- filter(IF_R, ID_SEGMENTO != "108")
IF_R <- filter(IF_R, ID_SEGMENTO != "109")
IF_R <- filter(IF_R, ID_SEGMENTO != "117")

IF_R_CARACTERISTICAS <- IF_R %>% mutate(FIBRA = ifelse(ID_TECNOLOGIA>=107 & ID_TECNOLOGIA<=113, 1, 0), FIBRA_ACC = ACCESOS * FIBRA) %>% select(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, MUNICIPIO, ID_EMPRESA, EMPRESA, ID_SEGMENTO, SEGMENTO, ID_TECNOLOGIA, FIBRA, FIBRA_ACC, TECNOLOGIA, VELOCIDAD_EFECTIVA_DOWNSTREAM, VELOCIDAD_EFECTIVA_UPSTREAM, ACCESOS) %>% arrange(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA, FIBRA, VELOCIDAD_EFECTIVA_DOWNSTREAM)
IF_R_CARACTERISTICAS <- merge(IF_R_CARACTERISTICAS, IF_R_CARACTERISTICAS %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(ACCESOS_mo=sum(ACCESOS), .groups = 'drop')) %>% mutate(w_mo = ACCESOS/ACCESOS_mo, VEL_BAJ = VELOCIDAD_EFECTIVA_DOWNSTREAM * w_mo, VEL_SUB = VELOCIDAD_EFECTIVA_UPSTREAM * w_mo, TEC_FIBRA = FIBRA * w_mo)
IF_R_CARACTERISTICAS <- IF_R_CARACTERISTICAS %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(VEL_BAJ = sum(VEL_BAJ), VEL_SUB = sum(VEL_SUB), TEC_FIBRA = sum(TEC_FIBRA), .groups = "drop")

CLUSTER <- read_excel("~/ClusterFijo.xlsx")
CLUSTER <- select(CLUSTER, DPMP, CLUSTER)
colnames(CLUSTER)[1] <- "ID_MUNICIPIO"

IF_R <- merge(IF_R, CLUSTER, by = c("ID_MUNICIPIO"), sort=F, all.x=TRUE)
IF_R <- filter(IF_R, CLUSTER != "Limitado")

IF_R$VALOR_FACTURADO_REAL <- ifelse(IF_R$ID_EMPRESA == "800153993", 3*IF_R$VALOR_FACTURADO_REAL, IF_R$VALOR_FACTURADO_REAL)

IF_R <- IF_R %>% group_by(FECHA, ANNO, TRIMESTRE, ID_MUNICIPIO, ID_EMPRESA) %>% summarise(ACCESOS = sum(ACCESOS), VALOR_FACTURADO = sum(VALOR_FACTURADO_REAL), .groups = 'drop') %>% as.data.frame()
IF_R$PRECIO <- IF_R$VALOR_FACTURADO / (3000*IF_R$ACCESOS)

IF_R$ID_DEPARTAMENTO <- floor(IF_R$ID_MUNICIPIO/1000)
IF_R$ID_DEPARTAMENTO <- as.numeric(ifelse(IF_R$ID_DEPARTAMENTO == "11", "25", IF_R$ID_DEPARTAMENTO))

IF_R <- merge(IF_R, IF_R %>% group_by(ANNO, TRIMESTRE, ID_MUNICIPIO) %>% summarise(TOTAL_ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame())
IF_R$SH <- IF_R$ACCESOS / IF_R$TOTAL_ACCESOS

IF_R <- filter(IF_R, ANNO > 2022)
IF_R <- merge(IF_R, IF_R %>% group_by(ID_MUNICIPIO, ID_EMPRESA) %>% summarise(S = sum(SH)/7, .groups = 'drop') %>% as.data.frame())
IF_R <- filter(IF_R, S > 0.04)
colnames(IF_R)[8] <- "P"

IF_R <- merge(IF_R, IF_R %>% group_by(ID_MUNICIPIO, ID_EMPRESA) %>% summarise(MP = mean(P), MEP = median(P), Q1P = quantile(P, 0.25), Q3P = quantile(P, 0.75), .groups = 'drop') %>% as.data.frame())
IF_R$IQR <- IF_R$Q3P - IF_R$Q1P
IF_R$LI <- IF_R$Q1P - 1.5*IF_R$IQR
IF_R$LS <- IF_R$Q3P + 1.5*IF_R$IQR
IF_R$P <- ifelse(IF_R$P > IF_R$LS, IF_R$MEP, IF_R$P)
IF_R$P <- ifelse(IF_R$P < IF_R$LI, IF_R$MEP, IF_R$P)

IF_R <- IF_R %>% group_by(ID_DEPARTAMENTO, ID_EMPRESA) %>% mutate(z_P = (sum(P) - P) / (n() - 1)) %>% ungroup()

IF_R <- merge(IF_R, IF_R %>% group_by(ANNO, TRIMESTRE, ID_MUNICIPIO) %>% summarise(S0 = 1 - sum(SH), .groups = 'drop') %>% as.data.frame())

IF_R$SHS0 <- log(IF_R$SH) - log(IF_R$S0)

MUNICIPIOS <- filter(MUNICIPIOS, AFECTADO > 0.01)

MUNICIPIOS <- select(MUNICIPIOS, ID_MUNICIPIO)

MUNICIPIOS$AFECTADO <- 1

IF_R <- merge(IF_R, MUNICIPIOS, by = c("ID_MUNICIPIO"), sort=F, all.x=TRUE)

IF_R <- filter(IF_R, AFECTADO == 1)

BD <- select(IF_R, FECHA, ID_MUNICIPIO, ID_EMPRESA, SHS0, S, SH, S0, P, z_P)
BD$ID_MUNICIPIO <- as.factor(BD$ID_MUNICIPIO)
BD <- merge(BD, IF_R_CARACTERISTICAS, by = c("FECHA", "ID_MUNICIPIO", "ID_EMPRESA"), sort=F, all.x=TRUE)

write_xlsx(BD, "a. BD.xlsx")
